#/bin/bash
# This script is to install Kubernetes on Ubuntu 22.04 LTS, with Calico as CNI
# This script used 10.244.0.0/16 as pod network CIDR. This network should not be used in your physical network.
# This script used Calico v3.27.0. You can change it to the latest version.

# Prerequisites
DEBIAN_FRONTEND=noninteractive sudo apt update
DEBIAN_FRONTEND=noninteractive sudo apt install curl gnupg2 software-properties-common apt-transport-https ca-certificates -y

# Docker
echo "Install Docker..."
aiur() { arg="$( cut -d ' ' -f 2- <<< "$@" )" && curl -sL https://gitlab.aiursoft.cn/aiursoft/aiurscript/-/raw/master/$1.sh | sudo bash -s $arg; }
aiur uninstall/docker
DEBIAN_FRONTEND=noninteractive sudo apt install docker.io -y

# Network
echo "Prepare network..."
cat <<EOF | sudo tee /etc/modules-load.d/k8s.conf
overlay
br_netfilter
EOF
sudo modprobe overlay
sudo modprobe br_netfilter
# sysctl params required by setup, params persist across reboots
cat <<EOF | sudo tee /etc/sysctl.d/k8s.conf
net.bridge.bridge-nf-call-iptables  = 1
net.bridge.bridge-nf-call-ip6tables = 1
net.ipv4.ip_forward                 = 1
EOF
sudo sysctl --system

# Runtime
echo "Prepare runtime to setup containerd..."
sudo mkdir /etc/containerd
sudo sh -c "containerd config default > /etc/containerd/config.toml"
sudo sed -i 's/ SystemdCgroup = false/ SystemdCgroup = true/' /etc/containerd/config.toml
sudo systemctl restart containerd.service
sudo systemctl restart kubelet.service

# K8S
curl -fsSL https://packages.cloud.google.com/apt/doc/apt-key.gpg | sudo gpg --dearmor -o /etc/apt/keyrings/kubernetes.gpg
echo "deb [arch=amd64 signed-by=/etc/apt/keyrings/kubernetes.gpg] http://apt.kubernetes.io/ kubernetes-xenial main" | sudo tee -a /etc/apt/sources.list
sudo apt update
DEBIAN_FRONTEND=noninteractive sudo apt install kubeadm kubelet kubectl kubernetes-cni -y

# Init (Only on Master)
sudo kubeadm config images pull
sudo kubeadm init --pod-network-cidr=10.244.0.0/16
read -p "Please copy the kubeadm join command above and run it on worker nodes. Press any key to continue..."

# Config (Only on Master)
mkdir -p $HOME/.kube
sudo cp -i /etc/kubernetes/admin.conf $HOME/.kube/config
sudo chown $(id -u):$(id -g) $HOME/.kube/config

# Calico (Only on Master)
kubectl create -f https://raw.githubusercontent.com/projectcalico/calico/v3.27.0/manifests/tigera-operator.yaml
curl https://raw.githubusercontent.com/projectcalico/calico/v3.27.0/manifests/custom-resources.yaml -O
sed -i 's/cidr: 192\.168\.0\.0\/16/cidr: 10\.244\.0\.0\/16/' custom-resources.yaml
kubectl create -f custom-resources.yaml
sudo systemctl restart kubelet.service

# Test (Only on Master)
kubectl get nodes -o wide
kubectl get pods --all-namespaces