using System.IO.Compression;
using Newtonsoft.Json;

public class Program
{
    public static async Task Main(string[] args)
    {
        var address =
                @"qb";
        var flPath = Path.Combine(Directory.GetCurrentDirectory(), "files.txt");
        var gzPath = Path.Combine(Directory.GetCurrentDirectory(), "files.txt.gz");
        var httpClient = new HttpClient();
        var response = await httpClient.GetAsync(address);
        var content = await response.Content.ReadAsStringAsync();
        var serverResponse = JsonConvert.DeserializeObject<ServerResponse>(content)!;
        var files = serverResponse.Files!.Select(x => x.Key).ToArray();
        
        // save files to files.txt and files.txt.gz
        await File.WriteAllLinesAsync(flPath, files);
        Console.WriteLine($"Files saved to {flPath}");
        
        // save files to files.txt.gz
        await using var fileStream = File.Create(gzPath);
        await using var gzipStream = new GZipStream(fileStream, CompressionMode.Compress);
        await using var writer = new StreamWriter(gzipStream);
        foreach (var file in files)
        {
            await writer.WriteLineAsync(file);
        }
        
        Console.WriteLine($"Files saved to {gzPath}");
        
        // Read the gz file back:
        //await ReadBack(gzPath);
    }

    private static async Task ReadBack(string gzFile)
    {
        await using var fileStream = File.OpenRead(gzFile);
        await using var gzipStream = new GZipStream(fileStream, CompressionMode.Decompress);
        using var reader = new StreamReader(gzipStream);
        var linesArray = (await reader.ReadToEndAsync()).Split(Environment.NewLine);
        foreach (var line in linesArray)
        {
            Console.WriteLine(line);
        }
    }
}

public class ServerResponse
{
    [JsonProperty("cr:itemType")]
    public string? ItemType { get; set; }
    
    [JsonProperty("cr:files")]
    public Dictionary<string, string>? Files { get; set; }
}