using System;

public class Program
{
    public static void Main()
    {
        Func<Func<string, string>, Func<string, string>> grammarFactory = (self) =>
        {
            return (input) =>
            {
                if (string.IsNullOrEmpty(input)) 
                    return "";

                if (input.StartsWith("A"))
                {
                    Console.WriteLine($"[逻辑层] 发现字符 'A'，吃掉它。剩余字符串: \"{input.Substring(1)}\" -> 呼叫 self 递归");
                    return self(input.Substring(1));
                }

                Console.WriteLine($"[逻辑层] 遇到非 'A' 字符 ('{input[0]}')，递归停止。");
                return input;
            };
        };

        Console.WriteLine("--- 构造解析器 ---");
        string testInput = "AAAB";
        Console.WriteLine($"\n--- 开始解析输入: \"{testInput}\" ---");
        
        string remaining = parser(testInput);

        Console.WriteLine($"\n--- 解析完成 ---");
        Console.WriteLine($"原始输入: {testInput}");
        Console.WriteLine($"剩余部分: {remaining}");
    }
}


public static class Combinator
{
    public static Func<T, R> Fix<T, R>(Func<Func<T, R>, Func<T, R>> f)
    {
        return input =>
        {
            Func<T, R> self = Fix(f);
            Func<T, R> actualLogic = f(self);
            return actualLogic(input);
        };
    }
}