#!/bin/bash

echo "Suppress Ubuntu ESM..."
export DEBIAN_FRONTEND=noninteractive
sudo pro config set apt_news=false
sudo rm /var/lib/ubuntu-advantage/messages/*
sudo rm /etc/apt/apt.conf.d/20apt-esm-hook.conf > /dev/null 2>&1

echo "Checking default password..."
username="anduin"
password="Password@1234_Super"

if echo "$password" | sudo -u anduin su - "$username" -c "true" > /dev/null 2>&1; then
  echo "Current machine using default password!" | sudo tee -a /etc/motd
  echo "Is default password. Should change!"
fi

echo "Setting timezone..."
sudo timedatectl set-timezone UTC

echo "Detecting space issues..."
CURRENT=$(df / | grep / | awk '{ print $5}' | sed 's/%//g')
THRESHOLD=60
if [ "$CURRENT" -gt "$THRESHOLD" ] ; then
    echo "Disk space alert! `date +"%Y-%m-%d %H:%M:%S"`  Your root partition remaining free space is critically low. Used: $CURRENT%" | sudo tee -a /etc/motd
fi

echo "Setting hosts..."
sudo cp /mnt/Shared/hosts /etc/
cat /etc/hosts

echo "Syncing time..."
echo "server openwrt prefer iburst" | sudo tee "/etc/ntp.conf"
sudo systemctl enable ntp
ntpstat

echo "Setting netplan..."
sudo rm /etc/netplan/*
sudo touch /etc/netplan/00-default-config.yaml
HOSTNAME=$(hostname)
IP_ADDRESS=$(awk -v host="$HOSTNAME" '$2 == host {print $1}' /etc/hosts)
# If not found, crash the script:
if [ -z "$IP_ADDRESS" ]; then
  echo "IP address not found for $HOSTNAME"
  exit 1
fi
echo "IP should be set to $IP_ADDRESS"
sudo tee /etc/netplan/00-default-config.yaml > /dev/null << EOF
network:
  version: 2
  renderer: NetworkManager
  ethernets:
    ens192:
      addresses:
       - $IP_ADDRESS/12
      dhcp4: no
EOF
sudo systemctl mask systemd-networkd-wait-online.service
sudo chown root:root /etc/netplan/00-default-config.yaml
sudo chmod 600 /etc/netplan/00-default-config.yaml
sudo netplan apply

echo "Setting network..."
#sudo systemctl restart NetworkManager
sudo ip route list
sudo ip route del default
sudo ip route del default
sudo ip route add default via 10.0.0.1 dev ens160 proto dhcp metric 100  # Green network
sudo ip route add default via 10.64.0.1 dev ens192 proto dhcp metric 101 # Blue network

echo "Removing snap..."
sudo systemctl disable --now snapd
sudo apt purge -y snapd
sudo rm -rf /snap /var/snap /var/lib/snapd /var/cache/snapd /usr/lib/snapd ~/snap
cat << EOF | sudo tee -a /etc/apt/preferences.d/no-snap.pref
Package: snapd
Pin: release a=*
Pin-Priority: -10
EOF
sudo chown root:root /etc/apt/preferences.d/no-snap.pref
echo "Snap removed"

echo "Removing prometheus..."
sudo apt autoremove prometheus-node-exporter -y
sudo rm /etc/systemd/system/multi-user.target.wants/prometheus-node-exporter.service > /dev/null 2>&1
sudo rm /etc/systemd/system/multi-user.target.wants/smartmontools.service > /dev/null 2>&1
sudo rm /etc/systemd/system/multi-user.target.wants/unattended-upgrades.service > /dev/null 2>&1

echo "Removing 45drives..."
sudo rm /etc/apt/sources.list.d/45drives.sources > /dev/null 2>&1
sudo rm /usr/share/keyrings/45drives-archive-keyring.gpg > /dev/null 2>&1

echo "Setting ufw..."
sudo ufw allow 22

echo "Updating packages..."
sudo apt update

echo "Installing monitoring..."
curl -sL http://monitoring:48466/install.sh | sudo bash

echo "Installing packages..."
sleep 5
sudo DEBIAN_FRONTEND=noninteractive apt install -y \
    apt-transport-https \
    ca-certificates \
    curl \
    lsb-release \
    software-properties-common \
    wget \
    git \
    jq \
    zip \
    unzip \
    vim \
    net-tools \
    dnsutils \
    nmap \
    htop \
    iotop \
    iftop \
    ntp \
    ntpdate \
    ntpstat \
    open-vm-tools
sleep 5
sudo DEBIAN_FRONTEND=noninteractive apt upgrade -y

echo "Removing deprecated packages..."
sleep 3
sudo DEBIAN_FRONTEND=noninteractive apt autoremove unattended-upgrades -y
sleep 3
sudo DEBIAN_FRONTEND=noninteractive apt --purge autoremove -y
sleep 3
sudo DEBIAN_FRONTEND=noninteractive apt install --fix-broken  -y
sleep 3
sudo DEBIAN_FRONTEND=noninteractive apt install --fix-missing  -y
sleep 3
sudo DEBIAN_FRONTEND=noninteractive dpkg --configure -a
sleep 3
