using System;
using System.Collections.Generic;
using System.IO;
using System.IO.Compression;
using System.Text.Json;

namespace JsonToGzip
{
    class Program
    {
        static void Main(string[] args)
        {
            // 输入输出文件路径
            string inputJsonPath = @"C:\Users\xuef\Downloads\a.json";
            string outputTxtPath = "files.txt";
            string outputGzPath = "files.txt.gz";

            // 读取 JSON 文件内容
            string jsonContent = File.ReadAllText(inputJsonPath);

            // 使用 System.Text.Json 解析 JSON
            using JsonDocument document = JsonDocument.Parse(jsonContent);
            JsonElement root = document.RootElement;

            // 存储输出的每一行
            List<string> lines = new List<string>();

            // 根据要求，输出顶层 "cr:itemType" 的属性名（而非它的值）
            if (root.TryGetProperty("cr:itemType", out JsonElement itemTypeElement))
            {
                lines.Add("cr:itemType");
            }

            // 遍历 "cr:files" 对象，将每个文件的键（即文件路径）添加到输出行中
            if (root.TryGetProperty("cr:files", out JsonElement filesElement))
            {
                foreach (JsonProperty file in filesElement.EnumerateObject())
                {
                    lines.Add(file.Name);
                }
            }

            // 将结果写入 files.txt，每个路径一行
            File.WriteAllLines(outputTxtPath, lines);

            // 使用 GZipStream 压缩生成 files.txt.gz
            using (FileStream originalFileStream = File.OpenRead(outputTxtPath))
            using (FileStream compressedFileStream = File.Create(outputGzPath))
            using (GZipStream compressionStream = new GZipStream(compressedFileStream, CompressionLevel.Optimal))
            {
                originalFileStream.CopyTo(compressionStream);
            }

            Console.WriteLine("生成文件 {0} 成功。", outputGzPath);
        }
    }
}
