#!/usr/bin/env bash
# compare_manifest.sh - Compare two manifest files and list packages present in the first but not the second.

set -euo pipefail

# Function to display usage information
usage() {
  echo "Usage: $0 <left.manifest> <right.manifest>"
  echo
  echo "Extracts package names (first column) from each manifest, sorts them," 
  echo "and prints packages present in the left file but not in the right."
  exit 1
}

# Ensure exactly two arguments are provided
if [[ $# -ne 2 ]]; then
  usage
fi

left_manifest="$1"
right_manifest="$2"

# Create a temporary directory for intermediate files
tmpdir=$(mktemp -d)
# Ensure the temporary directory is removed on script exit
trap 'rm -rf "${tmpdir}"' EXIT

# Extract package names (first column), sort, and write to temp files
awk '{print $1}' "${left_manifest}"   | sort > "${tmpdir}/left.txt"
awk '{print $1}' "${right_manifest}" | sort > "${tmpdir}/right.txt"

# Output the comparison result
echo "Packages in '${left_manifest}' but not in '${right_manifest}':"
comm -23 "${tmpdir}/left.txt" "${tmpdir}/right.txt"
