function Remove-AllNuGetPackageVersions($PackageId, $ApiKey)
{
    $lower = $PackageId.ToLowerInvariant();

    $json = Invoke-WebRequest -Uri "https://api.nuget.org/v3-flatcontainer/$lower/index.json" | ConvertFrom-Json

    foreach($version in $json.versions)
    {
      Write-Host "Unlisting $PackageId, Ver $version"
      Invoke-Expression "dotnet nuget delete $PackageId $version --non-interactive --api-key $ApiKey --source https://api.nuget.org/v3/index.json"
    }
}

Remove-AllNuGetPackageVersions -PackageId "MoongladePure.Web" -ApiKey "YOUR_KEY"