# 示例：对多个包执行Unlist操作
$packages = @(
    "Aiursoft.Archon.SDK",
    "Aiursoft.Developer.SDK",
    "Aiursoft.Directory.SDK",
    "Aiursoft.DocGenerator.Abstract",
    "Aiursoft.DotDownload.Core",
    "Aiursoft.Dotlang.Core",
    "Aiursoft.Gateway.SDK",
    "Aiursoft.Handler",
    "Aiursoft.Handler.Abstract",
    "Aiursoft.Pylon",
    "Aiursoft.SDK",
    "Aiursoft.SDK.Tests",
    "Aiursoft.SDKTools",
    "Aiursoft.SnakeGame",
    "Aiursoft.Stargate.SDK",
    "Aiursoft.Status.SDK",
    "Aiursoft.UiStack",
    "Aiursoft.Wrapgate.SDK",
    "Aiursoft.XelNaga",
    "AiurVersionControl",
    "AiurVersionControl.CRUD",
    "Anduin.HappyRecorder.Calendar",
    "Anduin.HappyRecorder.PluginFramework",
    "Anduin.QRCoder",
    "Anduin.QRCoder.NET",
    "Crawler.CLTeans",
    "Crawler.FantasticBodies",
    "Crawler.FlexyTeens",
    "Crawler.Shared",
    "DemoApiApp.Sdk",
    "Diff4Net.Core",
    "Kahla.SDK",
    "MoongladePure.Comments",
    "MoongladePure.Configuration",
    "MoongladePure.Core",
    "MoongladePure.Data",
    "MoongladePure.Data.MySql",
    "MoongladePure.FriendLink",
    "MoongladePure.ImageStorage",
    "MoongladePure.Syndication",
    "MoongladePure.Theme",
    "MoongladePure.Utils",
    "MoongladePure.Web",
    "NiBot"
)


$apiKey = "aaaaaaaaaaaaaaaaaaaaaaaaa"

function Remove-AllNuGetPackageVersions($PackageIds, $ApiKey)
{
    foreach ($PackageId in $PackageIds) {
        $lower = $PackageId.ToLowerInvariant()

        try {
            $json = Invoke-WebRequest -Uri "https://api.nuget.org/v3-flatcontainer/$lower/index.json" -ErrorAction Stop | ConvertFrom-Json

            foreach ($version in $json.versions) {
                Write-Host "Unlisting $PackageId, Version $version"
                Invoke-Expression "dotnet nuget delete $PackageId $version --non-interactive --api-key $ApiKey --source https://api.nuget.org/v3/index.json"
                Start-Sleep -Seconds 10
            }
        }
        catch {
            Write-Host "Error unlisting $PackageId $_" -ForegroundColor Red
        }
    }
}

Remove-AllNuGetPackageVersions -PackageIds $packages -ApiKey $apiKey

