echo "Downloading koel..."
sudo apt install tar wget jq
latestUrl=$(curl https://api.github.com/repos/koel/koel/releases/latest | jq -r '(.assets[] | select(.browser_download_url | contains(".zip"))).browser_download_url')
rm /tmp/koel.zip
rm /tmp/koel_ext -rf
wget -O /tmp/koel.zip $latestUrl

echo "Unziping koel..."
unzip /tmp/koel.zip -d /tmp/koel_ext

echo "Stoping service..."
sudo systemctl stop apache2.service

echo "Replacing files..."
sudo cp -rv /tmp/koel_ext/koel /var/www/html/

echo "Changing owners..."
sudo chown -R www-data:www-data /var/www/html/koel/
sudo chown -R www-data:www-data /mnt/data
find /var/www/html/koel -type d -print0 | sudo xargs -0 chmod 0755
find /var/www/html/koel -type f -print0 | sudo xargs -0 chmod 0644
find /mnt/data -type d -print0 | sudo xargs -0 chmod 0755
find /mnt/data -type f -print0 | sudo xargs -0 chmod 0644

echo "Configuring PHP..."
sudo sed -i '/^memory_limit =/s/=.*/= 8192M/' /etc/php/8.1/apache2/php.ini
sudo sed -i '/^upload_max_filesize =/s/=.*/= 16G/' /etc/php/8.1/apache2/php.ini
sudo sed -i '/^post_max_size =/s/=.*/= 16G/' /etc/php/8.1/apache2/php.ini
sudo sed -i '/^output_buffering =/s/=.*/= 0/' /etc/php/8.1/apache2/php.ini

echo "Restarting..."
sudo systemctl start apache2.service

echo "Migrating and syncing..."
sudo -u www-data php /var/www/html/koel/artisan migrate --force
sudo -u www-data php /var/www/html/koel/artisan koel:sync
sudo -u www-data php /var/www/html/koel/artisan koel:search:import