# Ubuntu install ISCSI Server
# Assuming the IP of the server is 10.0.0.1

# Mount a disk as /dev/sdb first
apt install tgt -y

# Edit /etc/tgt/conf.d/iscsi.conf
echo "
<target iqn.2024-03.iscsi.server:lun1>
    backing-store /dev/sdb
    initiator-address 10.0.0.2
    initiator-address 10.0.0.3
    initiator-address 10.0.0.4 # Add more if needed. These are the IPs of the clients
    incominguser iscsi-user password
    outgoinguser iscsi-target secretpass
</target>" | tee /etc/tgt/conf.d/iscsi.conf

systemctl restart tgt
tgtadm --mode target --op show

# Ubuntu install ISCSI Client
# Assuming the IP of the server is 10.0.0.2

apt install open-iscsi -y
iscsiadm -m discovery -t sendtargets -p 10.0.0.1 # This IP is the server IP
# You should see:
# 10.0.0.2:3260,1 iqn.2024-03.iscsi.server:lun1

# Edit /etc/iscsi/initiatorname.iscsi
echo "InitiatorName=iqn.2024-03.iscsi.server:lun1" | tee /etc/iscsi/initiatorname.iscsi

# Edit /etc/iscsi/nodes/iqn.2024-03.iscsi.server\:lun1/10.0.0.1\,3260\,1/default
echo "
node.session.auth.authmethod = CHAP
node.session.auth.username = iscsi-user
node.session.auth.password = password
node.session.auth.username_in = iscsi-target
node.session.auth.password_in = secretpass 
node.startup = automatic" | tee /etc/iscsi/nodes/iqn.2024-03.iscsi.server\:lun1/10.0.0.1\,3260\,1/default
systemctl restart open-iscsi iscsid
iscsiadm -m session -o show
lsblk