#!/bin/bash
sudo apt install jq dotnet7 -y

echo "Cleaning up..."
rm -rf /home/anduin/build
mkdir -p /home/anduin/build

echo "Downloading source code..."
wget https://gitlab.aiursoft.cn/aiursoft/moongladepure/-/archive/master/moongladepure-master.tar.gz -O /home/anduin/build/moongladepure-master.tar.gz

echo "Extracting source code..."
tar -zxf /home/anduin/build/moongladepure-master.tar.gz -C /home/anduin/build

echo "Building source code..."
dotnet publish -c Release -o /home/anduin/build/bin -r linux-x64 --no-self-contained /home/anduin/build/moongladepure-master/src/Moonglade.Web/MoongladePure.Web.csproj

echo 'Installing fonts...'
sudo mkdir /usr/share/fonts
sudo wget https://gitlab.aiursoft.cn/aiursoft/moongladepure/-/raw/master/assets/OpenSans-Regular.ttf -O /usr/share/fonts/OpenSans-Regular.ttf
sudo chown www-data:www-data /usr/share/fonts/OpenSans-Regular.ttf

curl https://gitlab.aiursoft.cn/aiursoft/moongladepure/-/raw/master/assets/tenants --output /tmp/tenants.txt
while read -r tenant port
do
    echo "Building tenant $tenant..."
    echo "His port is $port..."

    echo 'Stopping service...'
    sudo systemctl stop $tenant

    echo 'Creating tenant folder...'
    sudo mkdir -p /opt/apps/$tenant > /dev/null

    echo 'Copying files...'
    sudo cp /home/anduin/build/bin/* /opt/apps/$tenant/ -r

    echo 'Setting permissions...'
    sudo chown -R www-data:www-data /opt/apps/$tenant

    echo 'Creating appsettings.json...'
    sudo -u www-data cp /opt/apps/$tenant/appsettings.json /opt/apps/$tenant/appsettings.Production.json

    echo 'Setting appsettings.json...'
    sudo -u www-data jq --arg tenant "$tenant" '.ConnectionStrings.MoongladeDatabase = "Server=moongladedb;Port=3306;Database=" + $tenant + ";uid=moongladepure;Password=DATABASE_PASSWORD@1234;"' /opt/apps/$tenant/appsettings.Production.json | sudo -u www-data tee /tmp/tmp.json > /dev/null
    sudo -u www-data mv /tmp/tmp.json /opt/apps/$tenant/appsettings.Production.json
    sudo -u www-data jq '.ImageStorage.FileSystemPath = "/mnt/Store/'$tenant'"' /opt/apps/$tenant/appsettings.Production.json | sudo -u www-data tee /tmp/tmp.json > /dev/null
    sudo -u www-data mv /tmp/tmp.json /opt/apps/$tenant/appsettings.Production.json
    sudo -u www-data jq '.OpenAI.Token = "OPENAI-KEY"' /opt/apps/$tenant/appsettings.Production.json | sudo -u www-data tee /tmp/tmp.json > /dev/null
    sudo -u www-data mv /tmp/tmp.json /opt/apps/$tenant/appsettings.Production.json

    echo 'Creating service...'
    echo "[Unit]
Description=$tenant Service
After=network.target
Wants=network.target

[Service]
Type=simple
User=www-data
ExecStart=/usr/bin/dotnet /opt/apps/$tenant/MoongladePure.Web.dll --urls=http://0.0.0.0:$port/
WorkingDirectory=/opt/apps/$tenant
Restart=always
RestartSec=10
SyslogIdentifier=$tenant
KillSignal=SIGINT
Environment=\"ASPNETCORE_ENVIRONMENT=Production\"
Environment=\"DOTNET_PRINT_TELEMETRY_MESSAGE=false\"
Environment=\"DOTNET_CLI_TELEMETRY_OPTOUT=1\"
Environment=\"ASPNETCORE_FORWARDEDHEADERS_ENABLED=true\"

[Install]
WantedBy=multi-user.target" | sudo tee /etc/systemd/system/$tenant.service > /dev/null

    sudo systemctl daemon-reload
    sudo systemctl enable $tenant
    sudo systemctl start $tenant

done < /tmp/tenants.txt