#!/bin/sh
routerUser="root"
version="23.05.1"
#baseUrl="https://downloads.immortalwrt.org/releases/${version}/targets/x86/64"
baseUrl="https://immortalwrt.aiursoft.cn/releases/${version}/targets/x86/64" # Use mirror to speed up download
builderFileName="immortalwrt-imagebuilder-${version}-x86-64.Linux-x86_64.tar.xz"
pkgConfig="-dnsmasq dnsmasq-full ip-full vim vim-runtime -ethtool ethtool-full \
kmod-nf-nat kmod-nf-nat6 kmod-tls kmod-nft-arp kmod-nft-compat kmod-nft-connlimit kmod-nft-dup-inet kmod-nft-queue kmod-nft-socket kmod-nft-tproxy kmod-nft-xfrm kmod-nft-offload \
iptables-nft ip6tables-nft kmod-ipt-nat6 kmod-ipt-nat-extra kmod-ipt-nathelper-rtsp kmod-sched-mqprio kmod-ipt-offload \
kmod-e1000 kmod-e1000e kmod-igb kmod-ixgbe kmod-ixgbevf kmod-igc \
kmod-usb2 kmod-usb3 usbutils exfat-fsck exfat-mkfs kmod-fs-exfat kmod-usb-storage kmod-usb-storage-extras kmod-usb-storage-uas kmod-usb-serial kmod-usb-hid \
luci-i18n-opkg-zh-cn luci-i18n-firewall-zh-cn \
luci-i18n-passwall-zh-cn luci-app-passwall xray-core \
luci-app-upnp luci-i18n-upnp-zh-cn \
luci-app-wol luci-i18n-wol-zh-cn \
luci-app-banip luci-i18n-banip-zh-cn \
luci-app-watchcat luci-i18n-watchcat-zh-cn \
luci-app-uhttpd uhttpd \
luci-theme-bootstrap luci-theme-argon \
luci-app-statistics luci-i18n-statistics-zh-cn collectd-mod-disk collectd-mod-cpu collectd-mod-cpufreq collectd-mod-df collectd-mod-interface collectd-mod-processes collectd-mod-uptime collectd-mod-vmem collectd-mod-email collectd-mod-ethstat collectd-mod-conntrack collectd-mod-dhcpleases collectd-mod-syslog collectd-mod-write-http collectd-mod-ping collectd-mod-dns collectd-mod-memory collectd-mod-thermal collectd-mod-sensors collectd-mod-smart smartmontools smartmontools-drivedb \
umdns ca-bundle haveged wget wget-ssl iperf3 telnet-bsd speedtest-cli qrencode lm-sensors-detect lscpu lsblk uhubctl losetup bind-dig httping tcping \
"

bareMentalPackages="intel-microcode iucode-tool kmod-i2c-i801 kmod-w83627hf-wdt kmod-itco-wdt"
esxiPackages="kmod-vmxnet3 open-vm-tools open-vm-tools-fuse"
proxmoxPackages="virtio-console-helper qemu-ga"

echo "# STEP 0. Install prerequisites ..."
# Needs to run 'make'
DEBIAN_FRONTEND=noninteractive sudo apt update -y
DEBIAN_FRONTEND=noninteractive sudo apt install qemu-utils upx-ucl librsync-dev rsync unzip libncurses-dev subversion curl gawk -y

echo "# STEP 1. Gathering information ..."
echo "What platform are you building for? [Enter 'bare' for bare-metal, 'esxi' for VMware ESXi, 'proxmox' for Proxmox VE]:"
read platform
case $platform in
    bare)
        pkgConfig="$pkgConfig $bareMentalPackages"
        ;;
    esxi)
        pkgConfig="$pkgConfig $esxiPackages"
        ;;
    proxmox)
        pkgConfig="$pkgConfig $proxmoxPackages"
        ;;
    *)
        echo "Invalid platform. Exiting."
        exit 1
        ;;
esac

echo "# STEP 2. Downloading OpenWrt ${version} Image Builder ..."
if ! [ -f "./${builderFileName}" ]
then
    wget "$baseUrl/$builderFileName" -P .
fi
rm -rf ./builder
mkdir ./builder
tar xf ./$builderFileName -C ./builder/ --strip-components=1
cd ./builder

echo "# STEP 3. Preparing to build image ..."

# Change source from https://downloads.immortalwrt.org/ to https://immortalwrt.aiursoft.cn/
sed -i "s/https:\/\/downloads.immortalwrt.org/https:\/\/immortalwrt.aiursoft.cn/g" ./repositories.conf

# Set grub timeout to 0
sed -i 's/CONFIG_GRUB_TIMEOUT="[0-9]"/CONFIG_GRUB_TIMEOUT="0"/g' ./.config
# Image generation config
#sed -i "s/CONFIG_TARGET_ROOTFS_EXT4FS=y/CONFIG_TARGET_ROOTFS_EXT4FS=n/g" ./.config
sed -i "s/CONFIG_VHDX_IMAGES=y/CONFIG_VHDX_IMAGES=n/g" ./.config
sed -i "s/CONFIG_QCOW2_IMAGES=y/CONFIG_QCOW2_IMAGES=n/g" ./.config
sed -i "s/CONFIG_ISO_IMAGES=y/CONFIG_ISO_IMAGES=n/g" ./.config
#sed -i "s/CONFIG_VMDK_IMAGES=y/CONFIG_VMDK_IMAGES=n/g" ./.config
#sed -i "s/CONFIG_VDI_IMAGES=y/CONFIG_VDI_IMAGES=n/g" ./.config

# Language config
sed -i "s/# CONFIG_LUCI_LANG_en is not set/CONFIG_LUCI_LANG_en=y/g" ./.config

echo "# STEP 4. Building image ..."
make image PACKAGES="$pkgConfig" ROOTFS_PARTSIZE=1024 j=32 V=sc
echo "# DONE. See built images under: ./builder/bin/targets/x86/64/"