#!/usr/bin/env bash
set -euo pipefail

BASE_URL="https://anduinos-nightly-builds.aiursoft.cn/1.1"

# 定义所有语言的后缀
langs=(
  ar_SA de_DE en_US en_GB es_ES fr_FR it_IT ja_JP ko_KR nl_NL pl_PL
  pt_BR pt_PT ru_RU sv_SE th_TH tr_TR vi_VN zh_CN zh_HK zh_TW
)

# 遍历每种语言构造 .torrent 文件名并下载
for lang in "${langs[@]}"; do
  file="AnduinOS-1.1.6-${lang}.torrent"
  echo "Downloading $file ..."
  wget -c "${BASE_URL}/${file}"

  sha256="AnduinOS-1.1.6-${lang}.sha256"
  echo "Downloading $sha256 ..."
  wget -c "${BASE_URL}/${sha256}"
done


BASE_URL="https://anduinos-nightly-builds.aiursoft.cn/1.2"

# 定义所有语言的后缀
langs=(
  ar_SA de_DE en_US en_GB es_ES fr_FR it_IT ja_JP ko_KR nl_NL pl_PL
  pt_BR pt_PT ru_RU sv_SE th_TH tr_TR vi_VN zh_CN zh_HK zh_TW
)

# 遍历每种语言构造 .torrent 文件名并下载
for lang in "${langs[@]}"; do
  file="AnduinOS-1.2.6-${lang}.torrent"
  echo "Downloading $file ..."
  wget -c "${BASE_URL}/${file}"

  sha256="AnduinOS-1.2.6-${lang}.sha256"
  echo "Downloading $sha256 ..."
  wget -c "${BASE_URL}/${sha256}"
done

BASE_URL="https://anduinos-nightly-builds.aiursoft.cn/1.3"

# 定义所有语言的后缀
langs=(
  ar_SA de_DE en_US en_GB es_ES fr_FR it_IT ja_JP ko_KR nl_NL pl_PL
  pt_BR pt_PT ru_RU sv_SE th_TH tr_TR vi_VN zh_CN zh_HK zh_TW
)

# 遍历每种语言构造 .torrent 文件名并下载
for lang in "${langs[@]}"; do
  file="AnduinOS-1.3.3-${lang}.torrent"
  echo "Downloading $file ..."
  wget -c "${BASE_URL}/${file}"

  sha256="AnduinOS-1.3.3-${lang}.sha256"
  echo "Downloading $sha256 ..."
  wget -c "${BASE_URL}/${sha256}"
done
