
这里将在 3 台 node 上安装 ceph。三台 node 的 hostname 分别是：

* node1
* node2
* node3

三个 node 全部都插一块 **新的** 大硬盘。应该是 `sdb` 。是别的也无所谓。

## 开启root ssh

```bash
sudo vim /etc/ssh/sshd_config
```

将里面的  `PermitRootLogin` 改成 `yes`，将 `PasswordAuthentication` 改成 `yes`

```bash
sudo systemctl restart ssh sshd
```

## 改好密码

```bash
sudo su
passwd
```

设置一个 root 密码

## 关停服务 （可选）

如果你的盘已经配成了是基于 Glusterfs 的。先关停所有 Docker stack，然后关停 glusterfs 服务。

```bash
docker stack rm $(docker stack ls --format '{{.Name}}')
```

关掉 glusterfs。

```bash
sudo systemctl stop glusterd
sudo systemctl disable glusterd
```

取消挂载老盘，别忘了umount多个地点。对老盘跑

```bash
umount /swarm-vol
umount /var/no-direct-write-here/gluster-bricks
rm -rvf /swarm-vol
rm -rvf /var/no-direct-write-here/gluster-bricks
```

## 清空老盘

将老盘彻底抹除。抹除前记得备份。

```bash
fdisk /dev/sdb
d g w
```

## 准备 Ceph 文件

去那些node上

```bash
mkdir /etc/ceph
```

初始化ceph，在node1上运行

```bash
curl --silent --remote-name --location https://github.com/ceph/ceph/raw/octopus/src/cephadm/cephadm
chmod +x cephadm
mkdir -p /etc/ceph
./cephadm bootstrap --mon-ip $MYIP
```

等90秒，别忘了复制输出的内容。

把这些文件都拷到node2和node3上

```bash
scp /etc/ceph/ceph.conf root@node2:/etc/ceph/ceph.conf
scp /etc/ceph/ceph.conf root@node3:/etc/ceph/ceph.conf
scp /etc/ceph/ceph.client.admin.keyring root@node2:/etc/ceph/ceph.client.admin.keyring
scp /etc/ceph/ceph.client.admin.keyring root@node3:/etc/ceph/ceph.client.admin.keyring
scp /etc/ceph/ceph.pub root@node2:/root/.ssh/authorized_keys
scp /etc/ceph/ceph.pub root@node3:/root/.ssh/authorized_keys
```

都安装好ceph-common

```bash
apt install -y ceph-common
```

## 添加主机

```bash
ceph orch host add node2
ceph orch host add node3
ceph orch host ls
```

## 添加OSD

我们可以先让 Ceph 自动检测一波

```bash
ceph orch apply osd --all-available-devices
```

如果有问题，可以手动添加

```bash
ceph orch device zap node1 /dev/sdb --force
ceph orch device zap node2 /dev/sdb --force
ceph orch device zap node3 /dev/sdb --force
```

## 挂载新文件系统

```bash
echo "
# mount cephfs
node1,node2,node3:/ /swarm-vol ceph name=admin,noatime,_netdev 0 0
" | sudo tee -a /etc/fstab
sudo mkdir /swarm-vol
sudo mount /swarm-vol
```
