
这里将在 3 台 node 上安装 ceph。

三台 node 的 hostname 分别是：

* node1
* node2
* node3

三个 node 全部都插一块 **新的** 大硬盘。假如是 `/dev/sdb` 。

三个 node 最好是物理服务器，ceph 喜欢摸到真实的硬盘。

> 当然你非要用虚拟机也没什么问题，但是你都建设好虚拟机的存储系统了，为什么还需要 ceph ？？？

三个 node 之间没有防火墙，网是通的。

三个 node 你都需要使用 root 用户来执行命令。`sudo su`

> 虽然在 root 用户下面敲命令不是 Linux 的正确用法，但是 ceph 不喜欢非 root 用户。我承认这是它设计的不好。

## 开启root ssh

```bash
vim /etc/ssh/sshd_config
```

将里面的  `PermitRootLogin` 改成 `yes`，将 `PasswordAuthentication` 改成 `yes`

是的，这非常不优雅。ceph 喜欢用 root ssh 到各个 node 上一顿跑命令。但是它就是这么设计的。

```bash
systemctl restart ssh sshd
```

## 改好密码

```bash
passwd
```

设置一个 root 密码

## 关停服务 （可选）

如果你的盘已经配成了是基于 Glusterfs 的。先关停所有 Docker stack，然后关停 glusterfs 服务。

```bash
docker stack rm $(docker stack ls --format '{{.Name}}')
```

关掉 glusterfs。

```bash
sudo systemctl stop glusterd
sudo systemctl disable glusterd
```

取消挂载老盘，别忘了umount多个地点。对老盘跑

```bash
umount /swarm-vol
umount /var/no-direct-write-here/gluster-bricks
rm -rvf /swarm-vol
rm -rvf /var/no-direct-write-here/gluster-bricks
```

当然，如果你是新服务器，新盘，那没有这码子事儿。直接继续就行了。

## 清空老盘

将老盘彻底抹除。抹除前记得备份。

```bash
fdisk /dev/sdb
d g w
```

## 准备 Ceph 文件

去那些node上，每台 node 都要跑:

```bash
sudo mkdir /etc/ceph
```

每台 node 都安装 docker。ceph 天生就需要 docker 来部署它自己的许多组件。

```bash
curl -fsSL get.docker.com -o get-docker.sh
CHANNEL=stable sh get-docker.sh
rm get-docker.sh
```

初始化ceph，在node1上运行

```bash
curl --silent --remote-name --location https://github.com/ceph/ceph/raw/octopus/src/cephadm/cephadm
chmod +x cephadm
mkdir -p /etc/ceph
./cephadm bootstrap --mon-ip $MYIP # MYIP 是你的内网 IP 地址。
```

等90秒，别忘了复制输出的内容。

把这些文件都拷到node2和node3上

```bash
scp /etc/ceph/ceph.conf root@node2:/etc/ceph/ceph.conf
scp /etc/ceph/ceph.conf root@node3:/etc/ceph/ceph.conf
scp /etc/ceph/ceph.client.admin.keyring root@node2:/etc/ceph/ceph.client.admin.keyring
scp /etc/ceph/ceph.client.admin.keyring root@node3:/etc/ceph/ceph.client.admin.keyring
scp /etc/ceph/ceph.pub root@node2:/root/.ssh/authorized_keys
scp /etc/ceph/ceph.pub root@node3:/root/.ssh/authorized_keys
```

在主机上安装好ceph-common

```bash
apt install -y ceph-common
```

## 添加主机

```bash
ceph orch host add node2
ceph orch host add node3
ceph orch host ls
```

## 添加OSD

我们可以先让 Ceph 自动检测一波

```bash
ceph orch apply osd --all-available-devices
```

如果有问题，可以手动添加

```bash
ceph orch device zap node1 /dev/sdb --force
ceph orch device zap node2 /dev/sdb --force
ceph orch device zap node3 /dev/sdb --force
```

## 挂载新文件系统

```bash
echo "
# mount cephfs
node1,node2,node3:/ /swarm-vol ceph name=admin,noatime,_netdev 0 0
" | sudo tee -a /etc/fstab
sudo mkdir /swarm-vol
sudo mount /swarm-vol
```
