1. 准备工作区：立刻打开两个DMS两个OSP

2. 识别：识别有故障的范围，是版本还是Ring。在OSP检查此Ring趋势图。检查Substrate版本历史，确认其版本类型（Dogfood、Daily）。

```text
我正在检查 ________ 版本，范围是 Deploy Ring _________，其部署状况是 ______，版本类型是 ______。
```

3. 检查Override：

在OSP Overrides 页面搜索:

* 这个版本本身的信息
* 包含 999 的 override
* 最近的 10 个 override

检查是否被Halt，以及相关Override的修改时间。检查相关Incident。

*  如果有相关Override，找到正确责任组。结束
*  如果没有相关Override，转到步骤4

4. 进一步识别+验证：在DMS里使用gcam命令检查这个版本是否真的没有被部署。

```powershell
$machines = gcam -ShowAll -Filter "DeployRing -eq 'MSIT'" # 取出要调查的整个范围。

$machines | Where-Object { $_.DesiredMachineDefinition -eq 'BE' } | Group-Object ActualVersion | Sort-Object { $_.Name }
$machines | Where-Object { $_.DesiredMachineDefinition -eq 'FE' } | Group-Object ActualVersion | Sort-Object { $_.Name }
$machines | Where-Object { $_.DesiredMachineDefinition -eq 'AD' } | Group-Object ActualVersion | Sort-Object { $_.Name }
```

* 在这一步：确定不能部署的机器的Role

5. 检查期待性：在DMS里将机器按DesiredVersion Group，检查是否有机器试图部署这个版本。

```powershell
$machines | Where-Object { $_.DesiredMachineDefinition -eq 'BE' } | Group-Object DesiredVersion | Sort-Object { $_.Name }
```

* 如果有机器，证明机器正在Deploy但是失败了，前往步骤6。
* 如果没有机器，证明机器根本就没打算部署这个版本，前往步骤9。

6. 检查机器错误情况。抽样几台。检查其最近Workitem，观察错误

7. 使用Dots App交叉验证6。找到除了无法BeginMM以外最多的错误。

也可以使用下面的 Kusto:

```kusto
APSFailedWorkitemEvent_Global
| where env_time > ago(10h)
| where prioritizer contains "Sweeper:CapacityDeploymentSweeper"
//| where targetIntention contains "15.20.8032"
| where requestorMeta has 'TDF'
| where requestorMeta has 'BE'
| where requestorMeta has "DotBuildUpgrade"
| project failureTagId,resourceName,targetResourceUnit,targetIntention,deployRing,
failureWorkflowName,workflowId,workflowStartTime,failureTagWords,failureMessage,workflowEndTime,sku
| summarize Count=count() by failureWorkflowName
| sort by Count
| take 10
```

8. 找到错误的信息，检查日志，找到正确的责任人。

（注意：CAMgt3 的机器天生不跑 FastTrain，只装 Dogfood，就不再管了，而且只有Reimage能成功）

>结束

9. 如果整个Ring都有这个问题，则在Email中搜索 Ringbot \ Stagebot 相关的告警，检查是否 Ringbot \ Stagebot 工作异常：（TODO：这里要讨论并非整个Ring有问题的情况）
  

* 如果有，检查Ringbot的异常：Get-ScheduledWorkflow ringbot* | ft name, lastoperationid, isenabled 或 Invoke-RingbotValidateProdRings.ps1
* 如果没有，继续

10. 打开OSP的Ring Promo信息，观察是否这个版本被Promo

可以运行下面的引擎手工重启命令以强制触发它们重新评估。

```powershell
Request-ElevatedAccess_V2.ps1 -Role "ManagementDestructiveAccess" -Reason "Manual control deployment workflows" -DurationHours 12
Request-ElevatedAccess_V2.ps1 -Role "ManagementChangeAccess" -Reason "Manual control deployment workflows" -DurationHours 12

Start-DeploymentEngine.ps1
Start-BuildComponentListHandler.ps1
Start-Camgt2DeploymentHandler.ps1
Start-DotBuildValidationHandler.ps1
Start-EopStatefulDbHandler.ps1
Start-IngressRingBotPromotionHandler.ps1
Start-PrepareAdHandler.ps1
Start-SaturationHandler.ps1
Start-SeedComponentsHandler.ps1
Start-SeedPavcComponentsHandler.ps1
Start-WorkflowPairingHandler.ps1
```

* 如果有 Ring Promo，检查其欠缺的条件。如果有欠缺，则诊断欠缺的条件。如果全部满足，前往步骤14。
* 如果没有 Ring Promo，转到步骤11

11. 使用DMS See-Version，检查相关的

* deployment config workitem
* deployment config version
* deployment config approved version
* config prerequisite versions

```powershell
Get-DeploymentConfigWorkItem            -DeployRing WW -ApprovedVersion 15.20.7472.030 | ft -a
Get-DeploymentConfigVersion             -DeployRing WW -ApprovedVersion 15.20.7472.030 | ft -a
Get-DeploymentConfigApprovedVersion                    -ApprovedVersion 15.20.7472.030 | ft -a
Get-DeploymentConfigPrerequisiteVersion -EntityName BE -ApprovedVersion 15.20.7472.030 | ft -a
```

是否完整

12. 检查其前一个 Ring 有没有 config version 创建出来

* 如果有，转到步骤14
* 如果没有，转到步骤13

13. 考虑手工创建前一个Ring的Config Version，然后手工创建当前 Ring的 Config Workitem

```powershell
 Get-DeploymentConfigWorkItem -DeployRing MSIT -ApprovedVersion 15.20.7091.005 | ft -a
```

For: DeploymentEngine, SeedComponents, Saturation, BuildComponentList, PrepareAD, SeedPavcComponents, WorkflowPairing

```powershell
New-DeploymentConfigWorkItem `
  -DeployRing MSIT `
  -ApprovedVersion 15.20.7091.005 `
  -ServerRole BE `
  -HandlerType <-EACH-> `
  -DeploymentTrainType RegularTrain `
  -HandlerStatus Pending `
  -UserComments "Rerun PrepareAD with new build" `
  -CreatedBy xuef
```

 * 然后等待大约20分钟，重新执行此检查单

14. 检查相关的Deployment Config Workitem 是否执行完整

```powershell
 Get-DeploymentConfigWorkItem -DeployRing MSIT -ApprovedVersion 15.20.7091.005 | ft -a
```

15. 找到几台示例机器，检查APSPrioritizerLog，观察Message得知为何机器明明可以Deploy这个版本却为何不Deploy这个版本

在完成检查单后，使用下面的命令以检查是否有机器开始部署了：

```powershell
$msitUpgradingBe = gcam -ShowAll -Filter "DeployRing -eq 'MSIT' -and DesiredMachineDefinition -eq 'BE' -and DesiredVersion -like '15.20.7091.*' -and AutopilotMode -eq 'ApClient'"
```

> 结束