## 第三章 - 诊断剩余机器不部署的问题

1. 运行下面的查询来查看剩余机器信息

使用 CADW 数据库: [CADW](https://dataexplorer.azure.com/clusters/cadwprod.westus2/databases/Exchange)

```kusto
SubstrateMachine
| where ActivityState == "DotBuildUpgrade" and DesiredMachineDefinition == "BE"
| where ActualExchangeVersion contains "15.20.8534"
| where DeployRing in ('SIP', 'WW')
| extend unpatched = strcmp(ActualExchangeVersion, "15.20.8534.031") < 0
| summarize TotalCount=count(), unpatchedCount = countif(unpatched) by Forest
| extend UnPatchedPercentage = round(100.0 * unpatchedCount / TotalCount, 2)
| order by UnPatchedPercentage desc
```
