#include <iostream>
#include <functional>
std::function<int()> fibonacci()
{
    int current = 1, next = 1;
    return [=]() mutable {
        int result = current;
        current = next;
        next = current + result;
        return result;
    };
}
int main()
{
    auto fib = fibonacci();
    for (int i = 0; i < 10; i++) {
        std::cout << fib() << std::endl;
    }
    return 0;
} 
