## Install steps

* Make sure system installed with simple password and LUKS.
* Prepare mok-util to ensure MOK trust your own keys. Reboot.
* Prepare all drivers, modules. Build and sign the kernel and modules. Reboot.
* Prepare necessary tpm tools. Use dracut to replace initramfs-tools. Reboot.
* Use systemd-cryptenroll to change to a stronger password. Reboot.
* Enable Secure Boot
* Use systemd-cryptenroll to use TPM to auto unlock root partition. Reboot. Ensure auto unlock.

## Install dependencies

```bash
sudo apt install dracut libtss2-dev tpm2-tss-engine-tools tpm2-tools
```

* dracut: initrd manager.
* libtss -> TSS 2 user state tools and library
* tpm-tools
* engine-tools might not be needed.

```bash
anduin@anduin-lunar:~$ sudo cat /etc/crypttab 
nvme0n1p3_crypt UUID=9aacd8c2-e5f9-42bd-b345-f8617d0a668d none luks,discard,tpm2-device=auto
```

```bash
anduin@anduin-lunar:~$ cat /etc/dracut.conf.d/tpm2.conf 
add_dracutmodules+=" tpm2-tss "
```

```bash
sudo dracut -f --hostonly
```

(Reboot. mandatory)

## Ensure TPM device exists

```bash
sudo systemd-cryptenroll --tpm2-device=list
```

## Enlist all encryption methods

```bash
sudo systemd-cryptenroll /dev/nvme0n1p3 
```

## Make sure the PCR to bind.

https://uapi-group.org/specifications/specs/linux_tpm_pcr_registry/

* 0 BIOS itself
* 1 BIOS settings (optional)
* 2 PCIE Firmware option ROM (Suggested for desktop PC, optional for laptop)
* 7 Secure Boot
* 9 initrd
* 14 SHIM Mok

2,7,9,14

```bash
sudo systemd-cryptenroll --tpm2-device=auto --tpm2-pcrs="0+2+7+9+14" /dev/aaaaa
```

Enter existing LUKS pass.

## Update

Every time install kernel update:

```bash
sudo dracut -f --hostonly
```

Then reboot.

Then:

```bash
sudo systemd-cryptenroll --tpm2-device=auto --tpm2-pcrs="0+2+7+9+14" /dev/aaaaa
```

Optional to wipe:

```bash
sudo systemd-cryptenroll /dev/nvme0n1p3 --wipe-slot=1
```