# Create solution.
rm *.sln
dotnet new sln
find . -name *.csproj | xargs -I {} dotnet sln add {}

# Build projects
find . -name *.csproj | xargs -I {} dotnet publish {} -r win-x64 -c Release --self-contained

# Push all
for dir1 in ./*; do
    if [ -d "$dir1" ]; then
        echo "Pushing $dir1"
        cd "$dir1"
        git add .
        git commit -m "Upgrade to .NET 8"
        git push
        # 返回到原始目录
        cd ..
    fi
done
