// 函数：将视频元素设置为覆盖整个窗口
function makeVideoFullWindow(video) {
  console.log('Making video full window.');
  
  // 设置视频的样式，使其占据整个页面
  video.style.position = 'fixed';
  video.style.top = '0';
  video.style.left = '0';
  video.style.width = '100vw';
  video.style.height = '100vh';
  video.style.zIndex = '9999'; // 保证视频位于所有元素上方
  video.style.backgroundColor = 'black'; // 确保背景为黑色，避免干扰

  // 隐藏滚动条
  document.documentElement.style.overflow = 'hidden';

document.querySelectorAll('.nav_wrapper_bg.newtopbz').forEach(element => {
  element.remove();
})
document.querySelectorAll('.header_nav.newtopbzTV').forEach(element => {
  element.remove();
})
document.querySelectorAll('.phone').forEach(element => {
  element.remove();
})

  console.log('Video is now fullscreen-like.');
}

// 函数：恢复视频原始状态
function resetVideo(video) {
  console.log('Resetting video to original state.');

  // 恢复视频的样式
  video.style.position = '';
  video.style.top = '';
  video.style.left = '';
  video.style.width = '';
  video.style.height = '';
  video.style.zIndex = '';
  video.style.backgroundColor = '';

  // 恢复滚动条
  document.documentElement.style.overflow = '';
}

// 监听页面上所有的 <video> 元素
function setupVideoListeners() {
  const videos = document.querySelectorAll('video');
  console.log(`Found ${videos.length} video(s) on the page.`);
  
  videos.forEach(video => {
    video.addEventListener('play', () => {
      console.log('Video started playing, making it full window.');
      makeVideoFullWindow(video);

      // 当视频暂停或结束时，恢复原始状态
      video.addEventListener('pause', () => resetVideo(video), { once: true });
      video.addEventListener('ended', () => resetVideo(video), { once: true });
    });
  });
}

// 页面加载时，设置视频监听器
document.addEventListener('DOMContentLoaded', () => {
  console.log('DOM fully loaded and parsed, setting up video listeners.');
  setupVideoListeners();
});

// 动态加载的视频元素也需要监听，观察DOM变化
const observer = new MutationObserver(() => {
  console.log('DOM mutations detected, checking for new videos.');
  setupVideoListeners();
});

observer.observe(document.body, { childList: true, subtree: true });
