#include <iostream>
#include <vector>
#include <array>
#include <string>
#include <algorithm>
#include <ranges>
#include <utility>

// 1. 正常人类 (C++98)
void print_evens_c98(int arr[], int size) {
    for (int i = 0; i < size; i++) {
        if (arr[i] % 2 == 0) {
            std::cout << arr[i] << " ";
        }
    }
}

// 2. 稍微不正常 (C++11)
void print_evens_c11(const std::vector<int>& nums) {
    std::for_each(nums.begin(), nums.end(), [](int n) {
        if (n % 2 == 0) {
            std::cout << n << " ";
        }
    });
}

// 3. 再不正常一点 (C++20)
void print_evens_c20(const std::vector<int>& nums) {
    for (int n : nums | std::views::filter([](int n) { return n % 2 == 0; })) {
        std::cout << n << " ";
    }
}

// 4. 特别不正常 (C++20 纯编译期)
template <size_t... Is>
constexpr auto get_even_numbers_string_helper(const std::array<int, sizeof...(Is)>& arr, std::index_sequence<Is...>) {
    auto filter_and_convert = [&](auto index) constexpr {
        if (arr[index] % 2 == 0) {
            // Returns an empty string literal to avoid runtime heap allocation
            return std::to_string(arr[index]) + " ";
        }
        return std::string("");
    };
    return (filter_and_convert(Is) + ...);
}

template <size_t N>
void print_even_in_array(const std::array<int, N>& arr) {
    std::cout << get_even_numbers_string_helper(arr, std::make_index_sequence<N>{});
}

int main() {
    int arr[] = {5, 2, 8, 1, 6};
    std::vector<int> nums_vec = {5, 2, 8, 1, 6};
    
    constexpr std::array<int, 5> nums_arr_constexpr = {5, 2, 8, 1, 6};

    std::cout << "1. 正常人类 (C++98):" << std::endl;
    print_evens_c98(arr, 5);
    std::cout << "\n\n";

    std::cout << "2. 稍微不正常 (C++11):" << std::endl;
    print_evens_c11(nums_vec);
    std::cout << "\n\n";

    std::cout << "3. 再不正常一点 (C++20):" << std::endl;
    print_evens_c20(nums_vec);
    std::cout << "\n\n";

    std::cout << "4. 特别不正常 (C++20 纯编译期):" << std::endl;
    print_even_in_array(nums_arr_constexpr);
    std::cout << "\n";

    return 0;
}