#!/bin/bash

user_urls=(
    "https://space.bilibili.com/8776737/video"   # 阿江君
    "https://space.bilibili.com/20247643/video"  # 拉环儿_
    "https://space.bilibili.com/23945810/video"  # 爱抽卡的白熊
    "https://space.bilibili.com/287551041/video" # 一万根韭菜
    "https://space.bilibili.com/15232589/video"  # 白木哒哒哒
    "https://space.bilibili.com/6768352/video"   # 粥粥的奇妙冒险
    "https://space.bilibili.com/11742550/video"  # 哈米伦的弄笛者
    "https://space.bilibili.com/4128618/video"   # 大大大灯泡
    "https://space.bilibili.com/7086255/channel/collectiondetail?sid=611502" # 超想吃番茄 - 原神二创
    # more videos link here
)
cookies_path=./cookies.txt # export with https://addons.mozilla.org/en-US/firefox/addon/get-cookies-txt-locally/
outdir_root=/volumes/jellyfin/media/Bilibili
outpath="$outdir_root/%(uploader)s/%(title)s.%(ext)s"
video_format="bestvideo[height<=1080][ext=mp4]+bestaudio[ext=m4a]/best[ext=mp4]/best"
# video_format="bestvideo[ext=mp4]+bestaudio[ext=m4a]/best[ext=mp4]/best" # if you want 4k or higher

for url in "${user_urls[@]}"; do
    user_id=$(echo "$url" | grep -oP '(?<=bilibili.com/)[^/]+') # Extract the user ID from the URL
    archive="$outdir_root/archives/$user_id.txt"
    echo "Starting download $url"
    date
    yt-dlp \
        -f $video_format \
        --download-archive $archive \
        --cookies $cookies_path \
        --write-description \
        --write-info-json \
        --write-annotations \
        --write-thumbnail \
        --write-sub \
        --all-subs \
        --ignore-errors \
        --merge-output-format mp4 \
        --add-metadata \
        --embed-subs \
        --embed-thumbnail \
        --sleep-interval 50 \
        --max-sleep-interval 100 \
        -o $outpath $url
    sleep 600
done
