func primes() chan int {
    ch := make(chan int)
    go func() {
        defer close(ch)
        primes := []int{}
        for i := 2; ; i++ {
            isPrime := true
            for _, p := range primes {
                if p*p > i {
                    break
                }
                if i%p == 0 {
                    isPrime = false
                    break
                }
            }
            if isPrime {
                primes = append(primes, i)
                ch <- i
            }
        }
    }()
    return ch
}
