import os
import time

PLAYER_NAME = "Notch"
TMUX_SESSION_NAME = "minecraft"
SLEEP_DURATION = 6
CHUNK_SIZE = 16
VIEW_DISTANCE = 24
WORLD_SIZE = 4096
TP_STEP = CHUNK_SIZE * VIEW_DISTANCE
START_COORDINATE = WORLD_SIZE // 2

xz = [
    (x, z)
    for x in range(-START_COORDINATE, START_COORDINATE, TP_STEP)
    for z in range(-START_COORDINATE, START_COORDINATE, TP_STEP)
]
total = len(xz)
for i, v in enumerate(xz):
    x, z = v
    mc_commands = f"/tp {PLAYER_NAME} {x} ~100 {z}"
    tmux_commands = f'tmux send-keys -t {TMUX_SESSION_NAME} "{mc_commands}" Enter'
    print(tmux_commands)
    os.system(tmux_commands)
    print(f"{i}/{total} {x}/{z} done. {SLEEP_DURATION*(total-i)//60} minute remaining")
    time.sleep(SLEEP_DURATION)