repos=(
  cstools
  webtools
  docgenerator
  dbtools
  commandframework
  static
  ipmicontroller
  gitrunner
  aiurobserver
  cpprunner
  arraydb
  inmemorykvdb
  gptclient
  gitmirrorserver
  internalimages
  warp
  infrastructures
)

current_dir=$(pwd)
for repo in "${repos[@]}"; do

    # make sure the directory exists
    if [ ! -d "$repo" ]; then
        echo "Cloning $repo..."
        git clone "ssh://git@gitlab.aiursoft.cn:2202/aiursoft/$repo.git" || {
            echo "Error: failed to clone $repo" >&2
            exit 1
        }
    else
        echo "Skipping existing $repo"
    fi

    cd "$repo" || exit 1

    # make sure the branch is master
    git checkout master || {
        echo "Error: failed to checkout master branch for $repo" >&2
        exit 1
    }

    # pull the latest changes
    git pull origin master || {
        echo "Error: failed to pull latest changes for $repo" >&2
        exit 1
    }

    # execute the ninja command
    ninja all --path .
    
    # return to the original directory
    cd $current_dir || exit 1

done
